import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { queryResponse } from "../util/processResponse.js";

const initialState = {
    cart_Data: {},
    cartDataLength: 0,
    cartLoading: true,
    isError: false,
    error: "",
};

export const getCartProduct = createAsyncThunk(
    "cart/getCartProduct",
    async (obj) => {
        const { access_token, CARTURL } = obj;
        const response = await queryResponse(CARTURL, "GET", access_token);
        return response;
    }
);

const cartProductSlice = createSlice({
    name: "cart",
    initialState,
    reducers: {
        resetCartData: (state) => {
            state.cart_Data = {};
            state.cartDataLength = 0;
            state.cartLoading = true;
            state.isError = false;
            state.error = "";
        },
        deleteItemFromCart: (state, { payload }) => {
            const restData = state.cart_Data?.cartData.filter(
                (data) => data.index != payload
            );
            state.cart_Data = {
                ...state.cart_Data,
                cartData: restData,
            };
        },
        deleteGroupItemsFromCart: (state, { payload }) => {
            const restData = state.cart_Data?.cartData.filter(
                (data) => !payload.includes(data.index)
            );
            state.cart_Data = {
                ...state.cart_Data,
                cartData: restData,
            };
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getCartProduct.pending, (state) => {
            state.cartLoading = true;
        });
        builder.addCase(getCartProduct.fulfilled, (state, { payload }) => {
            const { status: { code } = {}, records } = payload || {};
            if (code === 200) {
                state.cart_Data = records.data;
                state.cartDataLength = records.data?.cartData?.length;
                state.isError = false;
            } else {
                state.cart_Data = {};
                state.cartDataLength = 0;
            }
            state.cartLoading = false;
        });
        builder.addCase(getCartProduct.rejected, (state, { payload }) => {
            state.cartLoading = false;
            state.isError = true;
            state.error = payload;
        });
    },
});

export default cartProductSlice.reducer;
export const { resetCartData, deleteItemFromCart, deleteGroupItemsFromCart } =
    cartProductSlice.actions;
